package jamezo97.clonecraft.entity;

import jamezo97.clonecraft.dna.ItemData;
import jamezo97.clonecraft.network.Handler2UpdateEntitySpawnEgg;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;

public class EntitySpawnEgg extends EntityThrowable{

	public ItemStack stack;
	
	public EntitySpawnEgg(World par1World, EntityLivingBase par2EntityLivingBase, ItemStack stack) {
		super(par1World, par2EntityLivingBase);
		this.stack = stack.copy();
	}

	public EntitySpawnEgg(World par1World) {
		super(par1World);
	}
	
	

	@Override
	public void writeEntityToNBT(NBTTagCompound nbt) {
		super.writeEntityToNBT(nbt);
		if(stack != null){
			NBTTagCompound nbtStack = new NBTTagCompound();
			stack.writeToNBT(nbtStack);
			nbt.setCompoundTag("ItemStack", nbtStack);
		}
	}

	@Override
	public void readEntityFromNBT(NBTTagCompound nbt) {
		super.readEntityFromNBT(nbt);
		NBTTagCompound nbtStack = nbt.getCompoundTag("ItemStack");
		if(!nbtStack.hasNoTags()){
			stack = ItemStack.loadItemStackFromNBT(nbtStack);
		}
	}

	@Override
	protected void onImpact(MovingObjectPosition mop) {
		if(stack != null){
			if(!worldObj.isRemote){
				Entity entity = new ItemData(stack).spawn(mop, this);
				if (entity != null)
				{
					if (entity instanceof EntityLivingBase && stack.hasDisplayName())
					{
						((EntityLiving)entity).setCustomNameTag(stack.getDisplayName());
					}
				}
			}else{
				worldObj.playSound(posX, posY, posZ, "clonecraft.pop", 1.0f, 1.0f, false);
			}
			worldObj.removeEntity(this);
			this.setDead();
		}
	}

	public void updateData() {
		new Handler2UpdateEntitySpawnEgg(stack, entityId).sendToAllWatching(this);
	}
	
}
